# For upstart, place this script in /etc/init/netagent.conf
# Change the BANYAN_DIR and SHIELD_ADDR values below.
description "Banyan Netagent"
chdir /opt/banyan

# Netagent logs will be written to /var/log/netagent.log
env BANYAN_DIR=/var/log/banyan
env com_banyanops_app=banyan-platform
env com_banyanops_servicename=netagentsvc
env com_banyanops_servicetype=visibility

# start in normal runlevels when disks are mounted and networking is available
start on runlevel [2345]

# stop on shutdown/halt, single-user mode and reboot
stop on runlevel [016]

# create a directory needed by the daemon
post-stop script
	/opt/banyan/netagent stop-net
end script

limit nofile 65536 65536

# redirect netagent stdout/stderr to /dev/null instead of /var/log/upstart/netagent.log
# console none
nice 10
exec /opt/banyan/netagent > /dev/null

# relaunch netagent whenever it exits due to an error or someone killing it accidentally
respawn
