# For systemd, place this script in /lib/systemd/system/netagent.service
# Change the HOME and SHIELD_ADDR values below.
# BANYAN_DIR: replace "LOG_DIR" with the directory that will contain netagent.log* log files.

[Unit]
Description=Banyan Netagent
After=network.target network-online.target

[Service]
WorkingDirectory=/opt/banyan
Environment=BANYAN_DIR=/var/log/banyan
Environment=com_banyanops_app=banyan-platform
Environment=com_banyanops_servicename=netagentsvc
Environment=com_banyanops_servicetype=visibility
LimitNOFILE=65536

Type=simple
Restart=on-failure
ExecStart=/opt/banyan/netagent
ExecStopPost=/opt/banyan/netagent stop-net
StandardOutput=journal
# StandardError=null
Nice=10

[Install]
WantedBy=multi-user.target
